// Header File
// Created 26/12/2003; 21:21:42
//Gestion de tirs en mode Shoot

//Gestion des missiles
static short MISSILE_xpos [20];
static short MISSILE_ypos [20];
static unsigned char MISSILE_racket [20];
static unsigned char nbrMissile=0;

//Taille d'un missile
#define MISSILE_SIZEX		3
#define MISSILE_SIZEY		7
#define MISSILE_SIZEX2	2
#define MISSILE_SIZEY2	6

#define MISSILE_ANIM_SIZEY	3
#define MISSILE_RIGHT				12

//Interruption
#define INT1_MISSILES											30
#define __INT1_MISSILES_FREQUENCY					3855
static unsigned short __COUNTER_MISSILES=0;

//Temps d'attente entre chaque tirs
#define MISSILES_TIME_SHOOT								2
#define MAX_MISSILES											3
BOOL STAT_MISSILES_KEY=FALSE;

//Animation des Missiles
unsigned short MISSILE_ANIM_xpos [20];
unsigned short MISSILE_ANIM_ypos [20];
unsigned char MISSILE_ANIM_sprite [20];
unsigned char nbrMissile_anim=0;

//Interruption
#define INT1_MISSILES_ANIM									3
#define __INT1_MISSILES_ANIM_FREQUENCY			385
static unsigned short __COUNTER_MISSILES_ANIM=0;

//Prototypes
void AddMissiles (short x, short y);
void CREATE_ANIM_MISSILE (short x, short y);

//Ajoute 2 missiles
void AddMissiles (short x, short y)
{
	//Missile 1
	MISSILE_xpos [nbrMissile]=x+7;
	MISSILE_ypos [nbrMissile]=y-6;
	
	//Missile sans appartenance
	MISSILE_racket [nbrMissile++]=0xFF;
}

//Efface un missile
void DeleteMissile (unsigned char item)
{	
	if (nbrMissile==20) return;
	
	StartIntMissiles=FALSE;
	
	memmove ((void *)(MISSILE_xpos+item),(void *)(MISSILE_xpos+item+1),(nbrMissile-item-1)<<1);
	memmove ((void *)(MISSILE_ypos+item),(void *)(MISSILE_ypos+item+1),(nbrMissile-item-1)<<1);
	memmove ((void *)(MISSILE_racket+item),(void *)(MISSILE_racket+item+1),nbrMissile-item-1);
	
	nbrMissile--;
	
	StartIntMissiles=TRUE;
}

//Dessine Missiles
void DrawMissiles (void)
{
	//Parcours Missiles
	for (int i=0;i<nbrMissile;i++)
	{
		//Si dans zone
		if (MISSILE_ypos [i]>=START_Y)
		{
			//Dessine ombre
			DrawSprite16_SHADOW (MISSILE_xpos [i]+2,MISSILE_ypos [i]+(MISSILE_SIZEY/2),MISSILE_SIZEY,SPRITE_MISSILE[0],ScreenBuffer);
		
			//Dessine missile
			FastGraySprite16_MASK_R (MISSILE_xpos [i],MISSILE_ypos [i],MISSILE_SIZEY,SPRITE_MISSILE[0],ScreenBuffer);
		}
	}
}

//Collision avec l'cran
void Missile_CollideWithScreen (void)
{
	//Parcours Missiles
	for (int i=0;i<nbrMissile;i++)
	{
		if (MISSILE_ypos [i]==START_Y)
		{
			//Retire missile
			if (MISSILE_racket [i]!=0xFF) Racket [MISSILE_racket [i]]->nbrMissile--;
			
			//Crer animation
			CREATE_ANIM_MISSILE (MISSILE_xpos [i],START_Y);
			
			//Efface Missile
			DeleteMissile (i--);
		}	
	}
}

//Tir utilisateur (HUMAIN)
void KEYS_Shoot (unsigned char item)
{
	//Si plus de joueur
	if ((item==0xFF) || !StartGameForHumain0) return;
	
	//Si appuie touche 2ND
	if (_keytest2 (RR_2ND))
	{
		//Si mode activ et racket forme vaisseau de tir
		if ((Racket [item]->shoot) && (Racket [item]->size==RACKET_SHOOT) && (Racket [item]->COUNTER_MISSILE_TIME_SHOOT>=MISSILES_TIME_SHOOT) && (Racket [item]->nbrMissile<MAX_MISSILES) && (STAT_MISSILES_KEY))
		{
			//Tir missile
			AddMissiles (Racket [item]->xpos, Racket [item]->ypos);
			MISSILE_racket [nbrMissile-1]=item;
			Racket [item]->nbrMissile++;
			
			//Remet le compteur  zro
			Racket [item]->COUNTER_MISSILE_TIME_SHOOT=0;
				
			//Etat clavier
			STAT_MISSILES_KEY=FALSE;
		}
	}
	else
		STAT_MISSILES_KEY=TRUE;
}

//*** ANIMATIONS ***
//Cration de l'animation Missile
void CREATE_ANIM_MISSILE (short x, short y)
{
	//Coordonnes
	MISSILE_ANIM_xpos [nbrMissile_anim]=x;
	MISSILE_ANIM_ypos [nbrMissile_anim]=y;
	
	//Sprite
	MISSILE_ANIM_sprite [nbrMissile_anim++]=1;
}

//Efface une animation
void DELETE_ANIM_MISSILE (unsigned char item)
{
	StartIntMissiles=FALSE;
		
	memmove ((void *)(MISSILE_ANIM_xpos+item),(void *)(MISSILE_ANIM_xpos+item+1),(nbrMissile_anim-item-1)<<1);
	memmove ((void *)(MISSILE_ANIM_ypos+item),(void *)(MISSILE_ANIM_ypos+item+1),(nbrMissile_anim-item-1)<<1);
	memmove ((void *)(MISSILE_ANIM_sprite+item),(void *)(MISSILE_ANIM_sprite+item+1),nbrMissile_anim-item-1);
	
	nbrMissile_anim--;
	
	StartIntMissiles=TRUE;
}

//Dessine animation Missiles
void DRAW_ANIM_MISSILES (void)
{
	//Parcours animations
	for (int i=0;i<nbrMissile_anim;i++)
	{
		//Affiche sprite
		if ((MISSILE_ANIM_sprite [i]<=2) && (MISSILE_ANIM_ypos [i]>=START_Y))
			FastGraySprite16_MASK_R (MISSILE_ANIM_xpos [i],MISSILE_ANIM_ypos [i],MISSILE_ANIM_SIZEY,SPRITE_MISSILE [MISSILE_ANIM_sprite [i]],ScreenBuffer);
	}
}

//Efface tous les missiles
void DeleteAllMissiles (void)
{
	//Parcours missiles
	for (int i=0; i<nbrMissile; i++)
		//Efface missile
		DeleteMissile (i--);
		
	//Efface animations
	for (int i=0; i<nbrMissile; i++)
		//Efface animations
		DELETE_ANIM_MISSILE (i--);
}